//
//  ViewController.m
//  sample
//
//  Created by savin on 13. 8. 7..
//  Copyright (c) 2013 savin. All rights reserved.
//


#ifdef _PRINTER_DELEGATE_ACTIONS_

//////////////////////////////////////////////////////////////////////////////////////
// (+)sbson[2011.08.02] : Start  BXPrinterController's Delegate
//////////////////////////////////////////////////////////////////////////////////////
#pragma mark BXPrinterController delegate Methods
//////////////////////////////////////////////////////////////////////////////////////

- (void)message:(BXPrinterController *)controller
text:(NSString *)text
{
    NSLog(@"[Sample message] %@", text);
    [_uiTextFieldStatus setText:text];

    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"sample" message:text delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
    [alert show];
    [alert release];
}



-(void)didUpdateStatus:(BXPrinterController*) controller
status:(NSNumber*) status
{
    NSLog(@"didUpdateStatus");
    [_uiTextFieldStatus setText:[NSString stringWithFormat:@"didUpdateStatus:%@", status]];
    
    
    _uiCoverStatus.text = (status.integerValue&BXL_STS_COVEROPEN)?@"OPENED": @"closeD";
    _uiPaperStatus.text = (status.integerValue&BXL_STS_PAPEREMPTY)?@"EMPTY": @"FILL";
}

- (void)outputComplete:(iController*) controller
outputID:(NSNumber*) outputID
errorStatus:(NSNumber*) errorStatus
{
    [_uiTextFieldStatus setText:[NSString stringWithFormat:@"outputComplete:%@, errorState:%@", outputID, errorStatus]];
}


- (void)errorEvent:(iController*) controller
errorStatus:(NSNumber*) errorStatus
{
    NSLog(@"errorEvent");
    [_uiTextFieldStatus setText:[NSString stringWithFormat:@"errorEvent - errorState:%@", errorStatus]];
}

- (void)msrArrived:(BXPrinterController *)controller
track:(NSNumber *)track
{
    NSLog(@"msrArrived");
    [_uiTextFieldStatus setText:@"msrArrived"];
    
    
    [_uiButtonMSR setTitle:@"MSR Ready" forState:UIControlStateNormal];

    NSData	*data = nil;
	if( [track intValue] & BXL_MSG_TRACK1 )
	{
		if( BXL_SUCCESS == [controller msrGetTrack:BXL_MSG_TRACK1 response:&data] )
		{
			_uiTextFieldTrack1.text	= [NSString stringWithFormat:@"%s", data.bytes];
		}
	}
	if( [track intValue] & BXL_MSG_TRACK2 )
	{
		if( BXL_SUCCESS == [controller msrGetTrack:BXL_MSG_TRACK2 response:&data] )
		{
			_uiTextFieldTrack2.text	= [NSString stringWithFormat:@"%s", data.bytes];
		}
	}
	if( [track intValue] & BXL_MSG_TRACK3 )
	{
		if( BXL_SUCCESS == [controller msrGetTrack:BXL_MSG_TRACK3 response:&data] )
		{
			_uiTextFieldTrack3.text	= [NSString stringWithFormat:@"%s", data.bytes];
		}
	}
}

- (void)msrTerminated:(BXPrinterController *)controller
{
    NSLog(@"msrTerminated");
    [_uiTextFieldStatus setText:@"msrTerminated"];
}

- (void)willLookupPrinters:(BXPrinterController *)controller
{
    NSLog(@"willLookupPrinters");
    [_uiTextFieldStatus setText:@"willLookupPrinters"];
    
}

- (void)didLookupPrinters:(BXPrinterController *)controller
{
    NSLog(@"didLookupPrinters");
    [_uiTextFieldStatus setText:@"didLookupPrinters"];
    
    [_pController selectTarget];
}

- (void)didFindPrinter:(BXPrinterController *)controller
printer:(BXPrinter *)printer
{
    NSLog(@"didFindPrinter \r\n    * target Name : %@    * target BDN : %@", printer.name, printer.bluetoothDeviceName);
    
    [_uiTextFieldStatus setText:@"didFindPrinter"];
    _pController.target = printer;
}

- (void)willConnect:(BXPrinterController *)controller
printer:(BXPrinter *)printer
{
    NSLog(@"willConnect");
    [_uiTextFieldStatus setText:@"willConnect"];
}

- (void)didConnect:(BXPrinterController *)controller
printer:(BXPrinter *)printer
{
    NSLog(@"didConnect");
    [_uiTextFieldStatus setText:@"didConnect"];
    
    NSLog(@"=========== Information Printing Start  ===========\r\n");
    NSLog(@" * printer modelStr : %@ \r\n", printer.modelStr);
    NSLog(@" * printer address : %@ \r\n", printer.address);
    NSLog(@" * printer macAddress : %@ \r\n", printer.macAddress);
    NSLog(@"=========== Information Printing Finish ===========\r\n");
}

- (void)didNotConnect:(BXPrinterController *)controller
printer:(BXPrinter *)printer
withError:(NSError *)error
{
    NSLog(@"didNotConnect");
    [_uiTextFieldStatus setText:@"didNotConnect"];
}

- (void)didDisconnect:(BXPrinterController *)controller
printer:(BXPrinter *)printer
{
    NSLog(@"didDisconnect");
    [_uiTextFieldStatus setText:@"didDisconnect"];
}

- (void)didBeBrokenConnection:(BXPrinterController *)controller
printer:(BXPrinter *)printer
withError:(NSError *)error
{
    NSLog(@"didBeBrokenConnection");
    [_uiTextFieldStatus setText:@"didBeBrokenConnection"];
}


- (void)targetPrinterPaired:(BXPrinterController*) controller
{
    NSLog(@"targetPrinterPaired");
    [_uiTextFieldStatus setText:@"connect avail able to your target"];
}

- (void)didBatteryState:(BXPrinterController*) controller
                  value:(NSInteger)value
{
    NSLog(@"%s",__FUNCTION__);
        switch (value) {
        case BXL_STATUS_BATT_FULL:
            [_uiTextFieldStatus setText:@"STATUS_BATT_FULL"];
            break;
        case BXL_STATUS_BATT_HIGH:
            [_uiTextFieldStatus setText:@"STATUS_BATT_HIGH"];
            break;
        case BXL_STATUS_BATT_MID:
            [_uiTextFieldStatus setText:@"STATUS_BATT_MID"];
            break;
        case BXL_STATUS_BATT_LOW:
            [_uiTextFieldStatus setText:@"STATUS_BATT_LOW"];
            break;
        default:
            break;
    }
}



#endif
